'use strict';

/* --------------------------------------------------------------
 cancel_modal.js 2016-10-12
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Cancel Order Modal Controller
 */
gx.controllers.module('cancel', ['modal'], function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES
    // ------------------------------------------------------------------------

    /**
     * Module Selector
     *
     * @type {jQuery}
     */

    var $this = $(this);

    /**
     * Module Instance
     *
     * @type {Object}
     */
    var module = {
        bindings: {
            selectedOrders: $this.find('.selected-orders'),
            reStock: $this.find('.re-stock'),
            reShip: $this.find('.re-ship'),
            reActivate: $this.find('.re-activate'),
            notifyCustomer: $this.find('.notify-customer'),
            sendComments: $this.find('.send-comments'),
            cancellationComments: $this.find('.cancellation-comments')
        }
    };

    if ($this.find('.cancel-invoice').length) {
        module.bindings.cancelInvoice = $this.find('.cancel-invoice');
    }

    // ------------------------------------------------------------------------
    // FUNCTIONS
    // ------------------------------------------------------------------------

    /**
     * Send the modal data to the form through an AJAX call.
     *
     * @param {jQuery.Event} event
     */
    function _onSendClick(event) {
        var url = jse.core.config.get('appUrl') + '/admin/admin.php?do=OrdersModalsAjax/CancelOrder';
        var data = {
            selectedOrders: module.bindings.selectedOrders.get().split(', '),
            reStock: module.bindings.reStock.get(),
            reShip: module.bindings.reShip.get(),
            reActivate: module.bindings.reActivate.get(),
            notifyCustomer: module.bindings.notifyCustomer.get(),
            sendComments: module.bindings.sendComments.get(),
            cancellationComments: module.bindings.cancellationComments.get(),
            pageToken: jse.core.config.get('pageToken')
        };

        if (module.bindings.cancelInvoice) {
            data.cancelInvoice = module.bindings.cancelInvoice.get();
        }

        var $sendButton = $(event.target);

        $sendButton.addClass('disabled').prop('disabled', true);

        $.ajax({
            url: url,
            data: data,
            method: 'POST',
            dataType: 'json'
        }).done(function (response) {

            for (var key in response.urls) {
                $.ajax({
                    type: "POST",
                    url: response.urls[key],
                    async: false
                });
            }

            jse.libs.info_box.addSuccessMessage(jse.core.lang.translate('CANCEL_ORDERS_SUCCESS', 'admin_orders'));
            $('.orders .table-main').DataTable().ajax.reload(null, false);
            $('.orders .table-main').orders_overview_filter('reload');
        }).fail(function (jqxhr, textStatus, errorThrown) {
            jse.libs.modal.message({
                title: jse.core.lang.translate('error', 'messages'),
                content: jse.core.lang.translate('CANCEL_ORDERS_ERROR', 'admin_orders')
            });
        }).always(function () {
            $this.modal('hide');
            $sendButton.removeClass('disabled').prop('disabled', false);
        });
    }

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    module.init = function (done) {
        $this.on('click', '.btn.send', _onSendClick);
        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
